/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class Mistnost
extends JFrame
implements Serializable {
    protected String nazev;
    public DannyList predmety;
    public DannyList inv;
    public JLabel cinn;
    protected JTextArea popis;
    private TlacitkoCinnosti prozkoumej;
    private TlacitkoCinnosti otevri;
    private TlacitkoCinnosti zavri;
    private TlacitkoCinnosti mluv;
    private TlacitkoCinnosti vezmi;
    private TlacitkoCinnosti pouzij;
    private JButton jdi;
    private JButton uloz;
    private JButton nahraj;
    private JButton oProgramu;
    private JButton konec;
    private JPanel tlacitkaCinnosti;
    private JPanel spodniPanel;

    public String getNazev() {
        return this.nazev;
    }

    public DannyList getPredmety() {
        return this.predmety;
    }

    public void setPredmety(DannyList dannyList) {
        this.predmety.removeAll();
        Object[] objectArray = dannyList.getItems();
        for (int i = 0; i < objectArray.length; ++i) {
            this.predmety.add((String)objectArray[i]);
        }
    }

    public void zeptejSeZdaUkoncitHru() {
        Object[] objectArray = new Object[]{"Ano", "Ne"};
        int n = JOptionPane.showOptionDialog(this, "Opravdu ukoncit hru?", "Opravdu ukoncit hru?", 0, -1, null, objectArray, objectArray[1]);
        if (n == 0) {
            System.exit(0);
        }
    }

    public abstract String vytvorPopis();

    public void aktualizujPopis() {
        this.popis.setText(this.vytvorPopis());
    }

    public void aktualizujInventar(DannyList dannyList) {
        this.inv.removeAll();
        Object[] objectArray = dannyList.getItems();
        for (int i = 0; i < objectArray.length; ++i) {
            this.inv.add((String)objectArray[i]);
        }
    }

    public void aktualizuj() {
        this.aktualizujPopis();
        this.aktualizujInventar(Zakladna.inventar);
        this.cinn.setText(Zakladna.cinnost.getText());
    }

    public void add(String string) {
        this.predmety.add(string);
    }

    public void remove(String string) {
        this.predmety.remove(string);
    }

    public void aktualizujRozsviceni() {
        this.ztmavTlacitka();
        String string = Zakladna.cinnost.getText();
        if (string.equals("prozkoumej")) {
            this.prozkoumej.rozsvit();
        } else if (string.equals("otevri")) {
            this.otevri.rozsvit();
        } else if (string.equals("zavri")) {
            this.zavri.rozsvit();
        } else if (string.equals("mluv")) {
            this.mluv.rozsvit();
        } else if (string.equals("vezmi")) {
            this.vezmi.rozsvit();
        } else if (string.startsWith("pouzij")) {
            this.pouzij.rozsvit();
        }
    }

    public Mistnost(String string, DannyList dannyList) {
        this.nazev = string;
        super.setTitle(Zakladna.nazevHry + " : " + this.nazev);
        this.setDefaultCloseOperation(0);
        this.popis = new JTextArea("", 20, 50);
        this.popis.setEditable(false);
        this.inv = new DannyList();
        this.inv.addItemListener(new HandlerCinnosti(this.inv));
        this.cinn = new JLabel();
        this.cinn.setHorizontalAlignment(0);
        this.predmety = dannyList;
        this.predmety.addItemListener(new HandlerCinnosti(this.predmety));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Mistnost.this.zeptejSeZdaUkoncitHru();
            }
        });
        this.aktualizuj();
        this.getContentPane().setLayout(new BorderLayout());
        this.prozkoumej = new TlacitkoCinnosti("prozkoumej");
        this.otevri = new TlacitkoCinnosti("otevri");
        this.zavri = new TlacitkoCinnosti("zavri");
        this.mluv = new TlacitkoCinnosti("mluv");
        this.vezmi = new TlacitkoCinnosti("vezmi");
        this.pouzij = new TlacitkoCinnosti("pouzij");
        this.jdi = new JButton("jdi...");
        this.jdi.setBackground(Zakladna.barva);
        this.jdi.addActionListener(new JitNekam());
        this.nahraj = new JButton("nahraj");
        this.nahraj.setBackground(Zakladna.barva);
        this.nahraj.addActionListener(new Loader());
        this.uloz = new JButton("uloz");
        this.uloz.setBackground(Zakladna.barva);
        this.uloz.addActionListener(new Saver());
        this.oProgramu = new JButton("o hre");
        this.oProgramu.setBackground(Zakladna.barva);
        this.oProgramu.addActionListener(Zakladna.aboutBox);
        this.konec = new JButton("konec");
        this.konec.setBackground(Zakladna.barva);
        this.konec.addActionListener(new UkoncovacHry());
        this.tlacitkaCinnosti = new JPanel();
        this.tlacitkaCinnosti.setLayout(new GridLayout(1, 7));
        this.tlacitkaCinnosti.add(this.prozkoumej);
        this.tlacitkaCinnosti.add(this.otevri);
        this.tlacitkaCinnosti.add(this.zavri);
        this.tlacitkaCinnosti.add(this.mluv);
        this.tlacitkaCinnosti.add(this.vezmi);
        this.tlacitkaCinnosti.add(this.pouzij);
        this.tlacitkaCinnosti.add(this.jdi);
        this.tlacitkaCinnosti.add(this.uloz);
        this.tlacitkaCinnosti.add(this.nahraj);
        this.tlacitkaCinnosti.add(this.oProgramu);
        this.tlacitkaCinnosti.add(this.konec);
        this.getContentPane().add((Component)this.popis, "Center");
        this.getContentPane().add((Component)this.cinn, "South");
        this.getContentPane().add((Component)this.tlacitkaCinnosti, "North");
        this.getContentPane().add((Component)this.predmety.getJScrollPane(), "West");
        this.getContentPane().add((Component)this.inv.getJScrollPane(), "East");
        this.pack();
        this.setLocation(150, 150);
        this.ztmavTlacitka();
        this.prozkoumej.rozsvit();
    }

    void ztmavTlacitka() {
        this.prozkoumej.ztmav();
        this.otevri.ztmav();
        this.zavri.ztmav();
        this.mluv.ztmav();
        this.vezmi.ztmav();
        this.pouzij.ztmav();
        this.jdi.setBackground(Zakladna.barva);
        this.konec.setBackground(Zakladna.barva);
    }

    class TlacitkoCinnosti
    extends JButton {
        public TlacitkoCinnosti(String string) {
            super(string);
            this.addActionListener(new Cinnost(string));
        }

        public void rozsvit() {
            this.setBackground(Color.magenta);
        }

        public void ztmav() {
            this.setBackground(Zakladna.barva);
        }
    }

    class Loader
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            boolean bl = true;
            try {
                Object object;
                fileInputStream = new FileInputStream(Zakladna.saveFileName);
                objectInputStream = new ObjectInputStream(fileInputStream);
                Zakladna.inventar = (DannyList)objectInputStream.readObject();
                Zakladna.povoleneMistnosti = (DannyList)objectInputStream.readObject();
                Zakladna.string2predmet = (HashMap)objectInputStream.readObject();
                Zakladna.string2vmistnosti = (HashMap)objectInputStream.readObject();
                Iterator iterator = Zakladna.string2mistnost.values().iterator();
                while (iterator.hasNext()) {
                    object = (Mistnost)iterator.next();
                    ((Mistnost)object).setPredmety((DannyList)Zakladna.string2vmistnosti.get(((Mistnost)object).getNazev()));
                }
                object = (String)objectInputStream.readObject();
                Zakladna.jdi.akce((String)object);
                objectInputStream.close();
                Zakladna.aktualizujMistnosti();
            }
            catch (IOException iOException) {
                Zakladna.legenda.ukaz("Nepodarilo se nahrat hru.\nSoubor " + Zakladna.saveFileName + " patrne neexistuje,\n" + "nebo neni v aktualnim adresari.");
                iOException.printStackTrace();
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                bl = false;
            }
            if (bl) {
                Zakladna.zprava.ukaz("Hra nahrana.");
            }
        }
    }

    class Saver
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            String string = Zakladna.kdeJsem.getNazev();
            try {
                fileOutputStream = new FileOutputStream(Zakladna.saveFileName);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(Zakladna.inventar);
                objectOutputStream.writeObject(Zakladna.povoleneMistnosti);
                objectOutputStream.writeObject(Zakladna.string2predmet);
                Iterator iterator = Zakladna.string2mistnost.values().iterator();
                while (iterator.hasNext()) {
                    Mistnost mistnost = (Mistnost)iterator.next();
                    Zakladna.string2vmistnosti.put(mistnost.getNazev(), mistnost.getPredmety());
                }
                objectOutputStream.writeObject(Zakladna.string2vmistnosti);
                objectOutputStream.writeObject(string);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Zakladna.zprava.ukaz("Hra ulozena.");
        }
    }

    class JitNekam
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Zakladna.jdi.polozky.removeAll();
            Object[] objectArray = Zakladna.povoleneMistnosti.getItems();
            for (int i = 0; i < objectArray.length; ++i) {
                Zakladna.jdi.polozky.add((String)objectArray[i]);
            }
            Zakladna.jdi.show();
        }
    }

    class UkoncovacHry
    implements ActionListener {
        UkoncovacHry() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mistnost.this.zeptejSeZdaUkoncitHru();
        }
    }

    class Cinnost
    implements ActionListener {
        private String wtf;

        public Cinnost(String string) {
            this.wtf = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mistnost.this.ztmavTlacitka();
            TlacitkoCinnosti tlacitkoCinnosti = (TlacitkoCinnosti)actionEvent.getSource();
            tlacitkoCinnosti.rozsvit();
            if (!this.wtf.startsWith("pouzij")) {
                Zakladna.predmetKPouziti = null;
            }
            Zakladna.cinnost.setText(this.wtf);
            Mistnost.this.cinn.setText(this.wtf);
        }
    }
}

