/*
 * Decompiled with CFR 0.152.
 */
package logika;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import logika.Vec;
import util.PredplatitelZmenyBatohu;
import util.VydavatelZmenyBatohu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batoh
implements VydavatelZmenyBatohu {
    private Set<Vec> veci;
    private List<PredplatitelZmenyBatohu> seznamPredplatitelu = new ArrayList<PredplatitelZmenyBatohu>();
    final int MAX_VECI;
    final int MAX_VAHA;

    public Batoh(int maxVeci, int maxVaha) {
        this.veci = new HashSet<Vec>();
        this.MAX_VECI = maxVeci;
        this.MAX_VAHA = maxVaha;
    }

    public void setVec(Vec vecicka) {
        this.veci.add(vecicka);
        this.upozorniPredplatitele();
    }

    public String getSeznamVeci() {
        String vracenyText;
        if (this.veci.size() == 0) {
            vracenyText = "\nV batohu nem\u00e1te \u017e\u00e1dn\u00e9 v\u011bci!";
        } else {
            vracenyText = "\nv\u011bci v batohu:";
            for (Vec v : this.veci) {
                vracenyText = vracenyText + " " + v.getNazev();
            }
        }
        return vracenyText;
    }

    public Set<Vec> getSeznamVeciSet() {
        return this.veci;
    }

    public Vec vyberVec(String nazevVeci) {
        Vec vybranaVec = null;
        for (Vec v : this.veci) {
            if (!v.getNazev().equals(nazevVeci)) continue;
            vybranaVec = v;
            return vybranaVec;
        }
        return null;
    }

    public int getAktualniVaha() {
        int vaha = 0;
        for (Vec v : this.veci) {
            vaha += v.getVaha();
        }
        return vaha;
    }

    public int getAktualneVeci() {
        int pveci = 0;
        for (Vec v : this.veci) {
            ++pveci;
        }
        return pveci;
    }

    public void odeberVec(Vec vec) {
        this.veci.remove(vec);
        this.upozorniPredplatitele();
    }

    @Override
    public void zaregistrujPredplatitele(PredplatitelZmenyBatohu predplatitel) {
        this.seznamPredplatitelu.add(predplatitel);
    }

    @Override
    public void odregistrujPredplatitele(PredplatitelZmenyBatohu predplatitel) {
        this.seznamPredplatitelu.remove(predplatitel);
    }

    @Override
    public void upozorniPredplatitele() {
        for (PredplatitelZmenyBatohu predplatitel : this.seznamPredplatitelu) {
            predplatitel.aktualizuj(this);
        }
    }
}

