/*
 * Decompiled with CFR 0.152.
 */
package grafika;

import grafika.OknoMistnosti;
import grafika.OknoNapovedy;
import grafika.PanelBatohu;
import grafika.PanelPlanku;
import grafika.PanelSObrazkem;
import grafika.PanelVychodu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import logika.Hra;

public class GUI {
    private JFrame hlavniOknoFrame;
    private JLabel zadejPrikazLabel;
    private JTextField vstupPrikazuTextField;
    private JTextArea vystupTextArea;
    private JPanel dolniPanel;
    private Hra hra;
    private OknoMistnosti oknoMistnosti;
    private OknoNapovedy oknoNapovedy;
    private PanelVychodu panelVychodu;
    private JMenuBar listaMenuBar;
    private JMenu souborMenu;
    private JMenu zobrazitMenu;
    private JMenu pomocMenu;
    private JMenuItem novaHraMenuItem;
    private JMenuItem konecMenuItem;
    private JMenuItem zobrazitMenuItem;
    private JMenuItem kProgramuMenuItem;
    private JMenuItem oProgramuMenuItem;
    private JMenuItem zobrazitPopisMenuItem;
    private PanelSObrazkem panelSObrazkem;
    private JDialog oknoPlanku;
    private PanelPlanku panelPlanku;
    private JMenuItem zobrazitPlanekMenuItem;
    private PanelBatohu panelBatohu;
    private JPanel levyPanel;
    private JPanel pravyPanel;

    public GUI(Hra hra) {
        this.hra = hra;
        this.initMenu();
        this.init();
        this.vystupTextArea.setText(hra.vratUvitani());
        this.vstupPrikazuTextField.requestFocus();
    }

    private void init() {
        this.hlavniOknoFrame = new JFrame();
        this.hlavniOknoFrame.setDefaultCloseOperation(3);
        this.hlavniOknoFrame.setTitle("PR\u016eMKA - v1.3");
        this.hlavniOknoFrame.setPreferredSize(new Dimension(720, 400));
        this.hlavniOknoFrame.setMinimumSize(new Dimension(550, 300));
        this.zadejPrikazLabel = new JLabel("Zadej p\u0159\u00edkaz: ");
        this.vystupTextArea = new JTextArea(13, 20);
        this.vystupTextArea.setMargin(new Insets(10, 15, 10, 10));
        this.vystupTextArea.setEditable(false);
        this.hlavniOknoFrame.add((Component)this.vystupTextArea, "Center");
        this.vstupPrikazuTextField = new JTextField(16);
        this.dolniPanel = new JPanel();
        this.dolniPanel.add(this.zadejPrikazLabel);
        this.dolniPanel.add(this.vstupPrikazuTextField);
        this.dolniPanel.setBackground(Color.LIGHT_GRAY);
        this.hlavniOknoFrame.add((Component)this.dolniPanel, "South");
        this.hlavniOknoFrame.add(new JScrollPane(this.vystupTextArea));
        this.pravyPanel = new JPanel();
        this.panelVychodu = new PanelVychodu(this.hra.getHerniPlan(), this);
        this.panelVychodu.setBorder(BorderFactory.createTitledBorder(" V\u00fdchody "));
        this.panelVychodu.setPreferredSize(new Dimension(90, 315));
        this.panelVychodu.setBackground(Color.WHITE);
        this.pravyPanel.setPreferredSize(new Dimension(100, 200));
        this.pravyPanel.setBackground(Color.LIGHT_GRAY);
        this.pravyPanel.add(this.panelVychodu);
        this.hlavniOknoFrame.add((Component)this.pravyPanel, "East");
        this.hlavniOknoFrame.setJMenuBar(this.listaMenuBar);
        this.levyPanel = new JPanel();
        this.panelSObrazkem = new PanelSObrazkem();
        this.panelSObrazkem.setPreferredSize(new Dimension(130, 120));
        this.panelSObrazkem.setBackground(Color.WHITE);
        this.panelBatohu = new PanelBatohu(this.hra.getBatoh(), this.hra);
        this.panelBatohu.setPreferredSize(new Dimension(130, 190));
        this.panelBatohu.setBackground(Color.WHITE);
        this.panelBatohu.setAlignmentX(0.0f);
        this.panelBatohu.setBorder(BorderFactory.createTitledBorder(" Batoh "));
        this.levyPanel.add((Component)this.panelSObrazkem, "North");
        this.levyPanel.add((Component)this.panelBatohu, "East");
        this.levyPanel.setPreferredSize(new Dimension(140, 240));
        this.levyPanel.setBackground(Color.LIGHT_GRAY);
        this.hlavniOknoFrame.add((Component)this.levyPanel, "West");
        this.hlavniOknoFrame.pack();
        this.hlavniOknoFrame.setResizable(false);
        this.hlavniOknoFrame.setLocation(5, 5);
        this.panelPlanku = new PanelPlanku(this.hra.getHerniPlan());
        this.oknoPlanku = new JDialog();
        this.oknoPlanku.setDefaultCloseOperation(1);
        this.oknoPlanku.setTitle("Pl\u00e1nek \u0161koly");
        this.oknoPlanku.add((Component)this.panelPlanku, "Center");
        this.oknoPlanku.setLocation(740, 5);
        this.oknoPlanku.setResizable(false);
        this.oknoPlanku.pack();
        this.oknoPlanku.setVisible(true);
        this.oknoMistnosti = new OknoMistnosti(this.hra.getHerniPlan());
        this.oknoNapovedy = new OknoNapovedy("/zdroje/napoveda.htm");
        this.vstupPrikazuTextField.requestFocus();
        this.vstupPrikazuTextField.addActionListener(new ZpracovaniPrikazu());
    }

    public void zaslatPrikaz(String prikaz) {
        String text = this.hra.zpracujPrikaz(prikaz);
        this.vystupTextArea.append("\n\n" + prikaz);
        this.vystupTextArea.append("\n" + text);
        this.vystupTextArea.setCaretPosition(this.vystupTextArea.getDocument().getLength());
        this.vstupPrikazuTextField.requestFocus();
        if (this.hra.konecHry()) {
            this.vstupPrikazuTextField.setEditable(false);
            this.panelVychodu.setVisible(false);
            this.oknoPlanku.setVisible(false);
        }
    }

    private void initMenu() {
        this.listaMenuBar = new JMenuBar();
        this.souborMenu = new JMenu("Soubor");
        this.souborMenu.setMnemonic(83);
        this.zobrazitMenu = new JMenu("Zobrazit");
        this.zobrazitMenu.setMnemonic(90);
        this.pomocMenu = new JMenu("Pomoc");
        this.pomocMenu.setMnemonic(80);
        this.novaHraMenuItem = new JMenuItem("Nov\u00e1 hra");
        this.novaHraMenuItem.setMnemonic(78);
        this.novaHraMenuItem.addActionListener(new NovaHra());
        this.novaHraMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl N"));
        this.souborMenu.add(this.novaHraMenuItem);
        this.souborMenu.addSeparator();
        this.konecMenuItem = new JMenuItem("Konec");
        this.konecMenuItem.setMnemonic(75);
        this.konecMenuItem.addActionListener(new KonecHry());
        this.souborMenu.add(this.konecMenuItem);
        this.zobrazitPopisMenuItem = new JMenuItem("Popis m\u00edstnosti");
        this.zobrazitPopisMenuItem.setMnemonic(80);
        this.zobrazitPopisMenuItem.addActionListener(new ZobrazeniPopisuMistnosti());
        this.zobrazitMenu.add(this.zobrazitPopisMenuItem);
        this.zobrazitPlanekMenuItem = new JMenuItem("Pl\u00e1nek \u0161koly");
        this.zobrazitPlanekMenuItem.setMnemonic(76);
        this.zobrazitPlanekMenuItem.addActionListener(new ZobrazeniPlanekMenuItem());
        this.zobrazitMenu.add(this.zobrazitPlanekMenuItem);
        this.kProgramuMenuItem = new JMenuItem("N\u00e1pov\u011bda k aplikaci");
        this.kProgramuMenuItem.setMnemonic(78);
        this.kProgramuMenuItem.addActionListener(new KProgramu());
        this.kProgramuMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.pomocMenu.add(this.kProgramuMenuItem);
        this.oProgramuMenuItem = new JMenuItem("O programu");
        this.oProgramuMenuItem.setMnemonic(79);
        this.oProgramuMenuItem.addActionListener(new OProgramu());
        this.pomocMenu.add(this.oProgramuMenuItem);
        this.listaMenuBar.add(this.souborMenu);
        this.listaMenuBar.add(this.zobrazitMenu);
        this.listaMenuBar.add(this.pomocMenu);
    }

    public void setVisible(boolean viditelnost) {
        this.hlavniOknoFrame.setVisible(viditelnost);
    }

    private class ZpracovaniPrikazu
    implements ActionListener {
        private ZpracovaniPrikazu() {
        }

        public void actionPerformed(ActionEvent e) {
            String radek = GUI.this.vstupPrikazuTextField.getText();
            GUI.this.vystupTextArea.append("\n\n" + radek);
            GUI.this.vystupTextArea.append("\n" + GUI.this.hra.zpracujPrikaz(radek));
            GUI.this.vstupPrikazuTextField.setText("");
            GUI.this.vystupTextArea.setCaretPosition(GUI.this.vystupTextArea.getDocument().getLength());
            if (GUI.this.hra.konecHry()) {
                GUI.this.vstupPrikazuTextField.setEditable(false);
                GUI.this.panelVychodu.setVisible(false);
                GUI.this.oknoPlanku.setVisible(false);
                GUI.this.oknoMistnosti.setVisible(false);
            }
        }
    }

    private class OProgramu
    implements ActionListener {
        private OProgramu() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JOptionPane.showMessageDialog(null, "<html><body><h2>Hra PR\u016eMKA</h2><p>Grafick\u00e9 prost\u0159ed\u00ed - <i>v1.0</i></p><p>J\u00e1dro - <i>v1.3</i></p><p>Autor: Martin Fi\u0161era</body></html>");
        }
    }

    private class ZobrazeniPlanekMenuItem
    implements ActionListener {
        private ZobrazeniPlanekMenuItem() {
        }

        public void actionPerformed(ActionEvent arg0) {
            GUI.this.oknoPlanku.setLocation(GUI.this.hlavniOknoFrame.getX() + GUI.this.hlavniOknoFrame.getWidth() + 15, GUI.this.hlavniOknoFrame.getY());
            GUI.this.oknoPlanku.setVisible(true);
        }
    }

    private class ZobrazeniPopisuMistnosti
    implements ActionListener {
        private ZobrazeniPopisuMistnosti() {
        }

        public void actionPerformed(ActionEvent arg0) {
            GUI.this.oknoMistnosti.setLocation(GUI.this.hlavniOknoFrame.getX(), GUI.this.hlavniOknoFrame.getY() + GUI.this.hlavniOknoFrame.getHeight() + 15);
            GUI.this.oknoMistnosti.setVisible(true);
        }
    }

    private class KProgramu
    implements ActionListener {
        private KProgramu() {
        }

        public void actionPerformed(ActionEvent arg0) {
            GUI.this.oknoNapovedy.setLocation(GUI.this.hlavniOknoFrame.getX(), GUI.this.hlavniOknoFrame.getY());
            GUI.this.oknoNapovedy.setVisible(true);
        }
    }

    private class KonecHry
    implements ActionListener {
        private KonecHry() {
        }

        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    }

    private class NovaHra
    implements ActionListener {
        private NovaHra() {
        }

        public void actionPerformed(ActionEvent arg0) {
            GUI.this.hra = new Hra();
            GUI.this.oknoMistnosti.nastaveniHernihoPlanu(GUI.this.hra.getHerniPlan());
            GUI.this.oknoMistnosti.setLocation(GUI.this.hlavniOknoFrame.getX() + 5, GUI.this.hlavniOknoFrame.getY() + GUI.this.hlavniOknoFrame.getHeight() + 10);
            GUI.this.panelVychodu.nastaveniHernihoPlanu(GUI.this.hra.getHerniPlan());
            GUI.this.vystupTextArea.setText(GUI.this.hra.vratUvitani());
            GUI.this.vstupPrikazuTextField.setEditable(true);
            GUI.this.panelVychodu.setVisible(true);
            GUI.this.panelBatohu.nastaveniBatohu(GUI.this.hra.getBatoh());
            GUI.this.panelPlanku.nastaveniHernihoPlanu(GUI.this.hra.getHerniPlan());
            GUI.this.vstupPrikazuTextField.requestFocus();
            GUI.this.oknoPlanku.setLocation(GUI.this.hlavniOknoFrame.getX() + GUI.this.hlavniOknoFrame.getWidth() + 15, GUI.this.hlavniOknoFrame.getY());
            GUI.this.oknoPlanku.setVisible(true);
        }
    }
}

