/*
 * Decompiled with CFR 0.152.
 */
package logika;

import java.util.HashSet;
import java.util.Set;
import logika.Vec;

public class Mistnost {
    private String nazev;
    private String popis;
    private Set<Mistnost> vychody;
    private Set<Vec> veci;
    private Boolean odemcena;

    public Mistnost(String nazev, String popis, Boolean odemcena) {
        this.nazev = nazev;
        this.popis = popis;
        this.odemcena = odemcena;
        this.vychody = new HashSet<Mistnost>();
        this.veci = new HashSet<Vec>();
    }

    public void setVychod(Mistnost vedlejsi) {
        this.vychody.add(vedlejsi);
    }

    public void setVec(Vec vecicka) {
        this.veci.add(vecicka);
    }

    public void setPopis(String popis) {
        this.popis = popis;
    }

    public void odemkni() {
        this.odemcena = true;
    }

    public void zamkni() {
        this.odemcena = false;
    }

    public boolean isOdemcena() {
        return this.odemcena;
    }

    public boolean equals(Object object) {
        if (object instanceof Mistnost) {
            Mistnost druha = (Mistnost)object;
            return this.nazev.equals(druha.nazev);
        }
        return false;
    }

    public int hashCode() {
        return this.nazev.hashCode();
    }

    public String getNazev() {
        return this.nazev;
    }

    public String dlouhyPopis() {
        return this.popis + ".\n" + this.seznamVychodu();
    }

    public String seznamVychodu() {
        String vracenyText = "v\u00fdchody:";
        for (Mistnost sousedni : this.vychody) {
            vracenyText = vracenyText + " " + sousedni.getNazev();
        }
        return vracenyText;
    }

    public String seznamVeci() {
        String vracenyText;
        if (this.veci.size() == 0) {
            vracenyText = "\nV t\u00e9to m\u00edstnosti nejsou \u017e\u00e1dn\u00e9 v\u011bci!";
        } else {
            vracenyText = "\nv\u011bci v m\u00edstnosti:";
            for (Vec v : this.veci) {
                vracenyText = vracenyText + " " + v.getNazev();
            }
        }
        return vracenyText;
    }

    public Mistnost sousedniMistnost(String jmenoSousedni) {
        if (jmenoSousedni == null) {
            return null;
        }
        for (Mistnost sousedni : this.vychody) {
            if (!sousedni.getNazev().equals(jmenoSousedni)) continue;
            return sousedni;
        }
        return null;
    }

    public Vec vyberVec(String nazevVeci) {
        Vec vybranaVec = null;
        for (Vec v : this.veci) {
            if (!v.getNazev().equals(nazevVeci)) continue;
            vybranaVec = v;
            return vybranaVec;
        }
        return null;
    }

    public void odeberVec(Vec vec) {
        this.veci.remove(vec);
    }
}

