/*
 * Decompiled with CFR 0.152.
 */
package grafika;

import java.awt.Dimension;
import java.net.URL;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import logika.Batoh;
import logika.Hra;
import logika.Vec;
import util.PredplatitelZmenyBatohu;

public class PanelBatohu
extends JPanel
implements PredplatitelZmenyBatohu {
    private Hra hra;

    public PanelBatohu(Batoh batoh, Hra hra) {
        this.hra = hra;
        batoh.zaregistrujPredplatitele(this);
        batoh.upozorniPredplatitele();
    }

    public void aktualizuj(Batoh batoh) {
        this.removeAll();
        Set<Vec> seznamVeci = batoh.getSeznamVeciSet();
        if (seznamVeci.size() != 0) {
            for (Vec v : seznamVeci) {
                JLabel obrazek = new JLabel(v.getNazev());
                URL cesta = this.getClass().getResource("/zdroje/" + v.getNazev() + ".gif");
                if (cesta != null) {
                    ImageIcon ikona = new ImageIcon(cesta);
                    obrazek.setIcon(ikona);
                } else {
                    JOptionPane.showMessageDialog(null, "Soubor s obr\u00e1zkem '" + v.getNazev() + ".gif" + "' nebyl nalezen", "Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed obr\u00e1zku", 0);
                }
                obrazek.setPreferredSize(new Dimension(45, 45));
                this.add(obrazek);
            }
        }
        this.repaint();
        this.revalidate();
    }

    public void nastaveniBatohu(Batoh batoh) {
        batoh.zaregistrujPredplatitele(this);
        this.aktualizuj(batoh);
    }
}

